<?php

/**
 * RoleModel
 */
class RoleModel
{

    /**
     * Get user role
     */
    public static function getUserRole($username="")
    {
        if($username){
          $database = DatabaseFactory::getFactory()->getConnection();

          $sql = "SELECT roles.role, users.vehicles FROM roles,users WHERE users.role=roles.id AND users.username=:username";
          $query = $database->prepare($sql);
          $query->execute(array(':username' => $username));
          $results = $query->fetch();

          return array('role' => $results->role, 'vehicles' => json_decode($results->vehicles));

        }
        else return "unassigned";
    }

    /**
     * Get permissions for a given role
     */
    public static function getPermissionsForRole($role)
    {
        $database = DatabaseFactory::getFactory()->getConnection();

        $sql = "SELECT permissions FROM roles WHERE role = :role";
        $query = $database->prepare($sql);
        $query->execute(array(':role' => $role['role']));
        $vehicles=$role['vehicles'];
        $permissions=json_decode($query->fetch(PDO::FETCH_ASSOC)['permissions'],true);
        $results=self::getDefaultPermissions();

        foreach($vehicles as $vehicle){
           foreach($permissions as $key => $value){
               $newkey=$vehicle."_".$key;
               $results[$newkey]=$value;
           }
        }
        //return json_decode($query->fetch(PDO::FETCH_ASSOC)['permissions'],true);

        return $results;
    }

    private static function getDefaultPermissions()
    {
        $database = DatabaseFactory::getFactory()->getConnection();

        $sql = "SELECT permissions FROM roles WHERE role = 'unassigned'";
        $query = $database->prepare($sql);
        $query->execute();
        $vehicles=self::getAllVehicles();
        $permissions=json_decode($query->fetch(PDO::FETCH_ASSOC)['permissions'],true);
        $results=array();
        foreach($vehicles as $vehicle){
           foreach($permissions as $key => $value){
               $newkey=$vehicle['id']."_".$key;
               $results[$newkey]=$value;
           }
        }
        return $results;

    }

    private static function getAllVehicles()
    {
        $database = DatabaseFactory::getFactory()->getConnection();

        $sql = "SELECT id FROM vehicle";
        $query = $database->prepare($sql);
        $query->execute();
        $vehicles=$query->fetchAll(PDO::FETCH_ASSOC);
        return $vehicles;

    }

}